using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;

namespace ThreadEvents
{
   class Program
   {
      static ManualResetEvent mre = new ManualResetEvent(false);
      static string sharedResource = "Zasb wspdzielony.";

      static void Main(string[] args)
      {
         Thread[] workers = new Thread[10];
         Console.WriteLine("Kolejkowanie wtkw...");
         for (int i = 0; i < 10; i++)
         {
            Thread worker = new Thread(new ThreadStart(DoWork));
            workers[i] = worker;
            worker.Start();
         }
         // wszystkie pozostae wtki otrzymuj chwil czasu na ustawienie si w kolejce za zdarzeniem resetujcym
         Thread.Sleep(TimeSpan.FromSeconds(2));
         Console.WriteLine("Wtki powinny by ju ustawione w kolejce, wysyam im sygna do pracy...");
         mre.Set();
         foreach (Thread worker in workers)
            worker.Join();
         Console.WriteLine("Praca zakoczona, wynik pracy: {0}", sharedResource);
         Console.ReadLine();
      }

      static void DoWork()
      {
         mre.WaitOne();
         lock (sharedResource)
         {
            Console.WriteLine("Praca moga zosta wykonana.");
            sharedResource += " zmodyfikowany. ";
         }
      }
   }
}
